var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"MAYAUL\">\n      <meta name=\"release\" content=\"2016\">\n      <meta name=\"book\" content=\"Tutorial\">\n      <meta name=\"created\" content=\"2015-10-30\">\n      <meta name=\"topicid\" content=\"GUID-56503DFE-8DF1-49DF-8BA7-8D23E633DFE5\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <title>Lesson 1: Converting the pants to nCloth and setting up the simulation</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-56503DFE-8DF1-49DF-8BA7-8D23E633DFE5\"></a><div class=\"head\">\n            <h1>Lesson 1: Converting the pants to nCloth and setting up the simulation</h1>\n         </div>\n         <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-400A\"></a>Before setting up the simulation environment, you need to convert the low resolution\n            pants mesh (Pants_LowRes) to an nCloth object. When the nCloth object is created,\n            an nClothShape and a Nucleus node are created. You can then set up the simulation\n            environment. \n            	 \n         </p>\n         <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C96\"></a>In this lesson, you will: \n            	 \n         </p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C95\"></a><ul>\n            <li>Convert the Pants_LowRes object to an nCloth object. \n               		\n            </li>\n            <li>Convert the Body and Shoe objects to passive collision objects. \n               		\n            </li>\n            <li>Set Nucleus solver properties, such as \n               		  <span class=\"MenuCascade\" id=\"GUID-9C9A480C-E88A-4D74-9D6B-AD9DBEC1AA00\">Time Attributes</span> and \n               		  <span class=\"MenuCascade\" id=\"GUID-C35F8CA5-38AC-4486-9FA6-40A11F9267C7\">Scale Attributes</span>. \n               		\n            </li>\n         </ul>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3D3E\"></a> \n            <h2><a name=\"GUID-2E52C6D7-5731-440E-A5A3-72E90A17585F\"></a>Converting the pants to nCloth\n            </h2> <a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3D3D\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3D3C\"></a>To convert the pants to nCloth\n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>Open \n                  			 <span class=\"code\">Character_LowRes_1.mb</span> in Maya. \n                  			 <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-48E3\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-DC6B3BCE-A66C-4D6A-AA55-AAF7081E6CD6-low.png\"></div> \n               </li>\n               <li>Make sure that only the low resolution pants (Pants_LowRes), Body, and Shoes are displayed\n                  in the scene view. \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62EC\"></a>If other objects are displayed, such as the Shirt_LowRes object, hide them by selecting\n                     each object in the \n                     				<span class=\"MenuCascade\" id=\"GUID-E67DD0BD-7BA0-4AF7-8A27-F013E24F5655\">Outliner</span> and selecting \n                     				<span class=\"MenuCascade\" id=\"GUID-2FA51398-7F4E-462B-93F9-37BF37021C20\">Display &gt; Hide &gt; Hide Selection</span>. \n                     			 \n                  </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-48E2\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-39D460C7-B85A-486E-B72A-A71919452B34-low.png\"></div> \n               </li>\n               <li>Select the Pants_LowRes object and select \n                  			 <span class=\"MenuCascade\" id=\"GUID-6DAFB09A-1949-47BE-94B1-16972FE596A9\">nCloth &gt; Create nCloth.</span>. \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF6026605B1181C8F4F2E-26B6\"></a>The low resolution pants are converted to an nCloth object, and its Maya Nucleus solver\n                     is created. \n                     			 \n                  </p> \n               </li>\n               <li>To ensure that all nCloth objects you create in this tutorial are easy to identify\n                  in your scene, rename the pants nCloth object. To do this, in the \n                  			 <span class=\"MenuCascade\" id=\"GUID-71F8BD02-8BF1-48BB-97BC-91660A26D78A\">Outliner</span>, double-click \n                  			 <em class=\"mild\">nCloth1</em>, type \n                  			 <em class=\"mild\">nCloth_Pants</em>, and press Enter. \n                  			 <a name=\"WS73099CC142F48755-789C4B1E11D24BE26D7-5890\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-6937B934-F6A4-47A0-9DCA-B64DCDAC49E8-low.png\"></div> \n               </li>\n               <li>Play back your simulation. \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62EB\"></a>When you playback the simulation, you notice that the nCloth is not responding to\n                     the Nucleus forces, meaning it is not being simulated. In the next steps, you adjust\n                     the scene’s start frame so that your nCloth is simulated. \n                     			 \n                  </p> \n               </li>\n            </ol> \n         </div>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3D34\"></a> \n            <h2><a name=\"GUID-CFFB6347-A8CA-44E3-B8C3-C9E11F195E99\"></a>Setting up the simulation\n            </h2> \n            <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-73AC\"></a>Before you begin simulating nCloth, it is important to adjust the Nucleus solver properties\n               to suit your simulation. The Maya Nucleus solver properties control internal forces\n               that affect all of the nodes that are members of a particular solver system. \n               		\n            </p> \n            <p><a name=\"WS73099CC142F48755-789C4B1E11D24BE26D7-588F\"></a> One of the most important Nucleus solver attributes to be aware of is \n               		  <span class=\"MenuCascade\" id=\"GUID-CA432F4B-3C3D-4517-8DA2-964237349B55\">Space Scale</span>. When \n               		  <span class=\"MenuCascade\" id=\"GUID-DD36A403-20A5-4A6B-8A14-1483CE6F2E7D\">Space Scale</span> is set to its default value of 1, the Nucleus solver applies \n               		  <span class=\"MenuCascade\" id=\"GUID-7ACD2CF2-00E7-4964-B687-BC4C07BEE2B7\">Gravity</span> and \n               		  <span class=\"MenuCascade\" id=\"GUID-5A968290-35D5-4585-AB22-9CDD224FE53A\">Wind</span> to objects as if the objects were scaled in meters. In some production pipelines,\n               the geometry that is used in nCloth simulation is modeled as life size or in large\n               scale, and so \n               		  <span class=\"MenuCascade\" id=\"GUID-B6814884-1BEB-4695-8C1B-A25368216A5F\">Space Scale \n                  		  </span>needs to be adjusted to compensate for the difference in scale. For more information,\n               see \n               		  <em class=\"mild\">Maya Nucleus solver properties</em> in the Maya Help.\n               		\n            </p> \n            <div class=\"section\"><a name=\"WS73099CC142F48755-1EB804411AF8B41570-73AB\"></a> \n               <h3><a name=\"GUID-F71DF516-D4DA-41CD-85F4-211396E50C92\"></a>Setting Nucleus solver attributes\n               </h3> \n               <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3D32\"></a>For this tutorial, the \n                  			 <span class=\"MenuCascade\" id=\"GUID-6E3D6C61-594E-4D21-BBE3-F5A2899EA28F\">Time Slider</span> settings specify the Playback time of the scene to start at frame 1000 and end at\n                  frame 1150. By default, the Nucleus solver starts simulations at frame 1. To begin\n                  simulating the scene, set the \n                  			 <span class=\"MenuCascade\" id=\"GUID-BF041D54-06F0-446C-8983-8FA66C4CF16C\">Start Frame</span> of the simulation to frame 1000. \n                  		  \n               </p> <a name=\"WS73099CC142F48755-1EB804411AF8B41570-73AA\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3D30\"></a>To set the simulation \n                  			 <span class=\"MenuCascade\" id=\"GUID-BCE442DE-0B02-40E8-AF8B-B73E34BC01BC\">Start Frame</span></p>\n               <ol type=\"1\" start=\"1\">\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-D8FA6DBB-FA5E-4272-891B-47E35F409C2F\">Attribute Editor</span>, select the \n                     				<span class=\"MenuCascade\" id=\"GUID-28A64519-1CD0-475E-AC40-18C59B133367\">nucleus1</span> tab. \n                     			 \n                  </li>\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-44C4F510-D381-4424-A642-AAE48569F7C9\">Time Attributes</span> section, set the \n                     				<span class=\"MenuCascade\" id=\"GUID-1BFE7941-EBB6-4B2D-9446-B5246348D95E\">Start Frame</span> to 1000. \n                     				<a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-48DF\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-ED48566E-E6B0-4BB8-B3E2-010162E093ED-low.png\"></div> \n                  </li>\n                  <li>Rewind to the start frame and play back your simulation. \n                     			 \n                  </li>\n               </ol> \n               <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-73A9\"></a>When you play back the simulation, you notice that the nCloth pants are falling under\n                  the influence of gravity generated by the Nucleus solver. However, they fall too slowly\n                  to be realistic. This occurs when the scale of the objects in your scene do not match\n                  the scale of the Nucleus solver system. Since the Nucleus solver simulates as if centimeters\n                  were meters, you need to adjust the \n                  			 <span class=\"MenuCascade\" id=\"GUID-FE654674-F00D-4FCF-A83C-58755020C0CE\">Space Scale</span> of the Maya Nucleus solver. In this scene, the character and clothing meshes have\n                  been modeled using centimeters as the Maya scene units. Therefore, to simulate your\n                  nCloth objects (which were modeled life-size), you need to set \n                  			 <span class=\"MenuCascade\" id=\"GUID-3B6322F5-5832-4695-A06E-4421D1F27416\">Space Scale</span> to 0.01. \n                  		  \n               </p> <a name=\"WS73099CC142F48755-1EB804411AF8B41570-73A8\"></a><p class=\"list-intro\"><a name=\"WS73099CC142F48755-1EB804411AF8B41570-73A7\"></a>To edit \n                  			 <span class=\"MenuCascade\" id=\"GUID-FB41568A-F01D-4BE3-AAAA-535D4A061BAB\">Space Scale</span></p>\n               <ol type=\"1\" start=\"1\">\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-5863426E-A069-43A2-B34A-695205F9B417\">Scale Attributes</span> section or the \n                     				<span class=\"MenuCascade\" id=\"GUID-E75C053E-ECAC-4BB5-9DED-5950643A137E\">nucleus1</span> tab, set the \n                     				<span class=\"MenuCascade\" id=\"GUID-2145E015-74F5-4FF0-B133-1C55405EBFD8\">Space Scale</span> to 0.01. \n                     				<a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-48DE\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-F5EE50F0-E7AA-40EF-B0C6-F6F37534B250-low.png\"></div> \n                     <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3D2A\"></a>When you reduce the \n                        				  <span class=\"MenuCascade\" id=\"GUID-DC188AC6-7225-473A-B8A6-985F032FD7FA\">Space Scale \n                           				  </span>attribute, Maya evaluates the pants as if they are a much smaller object. The result\n                        is a visibly increased gravitational affect on the nCloth pants object. \n                        				\n                     </p> \n                  </li>\n                  <li>Play back your simulation. \n                     			 \n                  </li>\n               </ol> \n               <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-73A5\"></a>When you play back the simulation, you notice that the nCloth pants now fall from\n                  the start position at a realistic speed, however they are falling out of the scene.\n                  To stop the pants from falling out of the scene view, turn on the Nucleus \n                  			 <span class=\"MenuCascade\" id=\"GUID-8EC56C65-FD43-413A-9147-4217E1DC29C2\">Ground Plane</span>. \n                  		  \n               </p> <a name=\"WS73099CC142F48755-1EB804411AF8B41570-73A4\"></a><p class=\"list-intro\"><a name=\"WS73099CC142F48755-1EB804411AF8B41570-73A3\"></a>To turn on the Nucleus \n                  			 <span class=\"MenuCascade\" id=\"GUID-1B96C01D-A10A-4D2D-BB44-A7A35A31E702\">Ground Plane</span></p>\n               <ol type=\"1\" start=\"1\">\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-C4A3EA7E-F099-4F3A-BB90-8B6E603ED025\">Ground Plane</span> section of the \n                     				<span class=\"MenuCascade\" id=\"GUID-3A2F9D51-73C9-4DA0-9CAF-753A5088257B\">nucleus1</span> tab, turn on \n                     				<span class=\"MenuCascade\" id=\"GUID-F65A86E5-DCFE-45F6-8AD9-F2F97BAEEA58\">Use Plane</span>. \n                     				<a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-48DD\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-C032E36D-C103-4555-8219-BFC08074E847-low.png\"></div> \n                  </li>\n                  <li>Play back the simulation. \n                     				\n                     <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62EA\"></a>When you play back the simulation, you notice that the pants are not colliding with\n                        the body and shoe objects. This is because the body and shoe meshes are not yet part\n                        of the nCloth’s Nucleus system. In the next step, you convert these objects to passive\n                        collision objects. \n                        				\n                     </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E3F\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-B3875E9D-CF03-41A1-9892-FAB0957A2E05-low.png\"></div> \n                  </li>\n               </ol> \n            </div> \n            <div class=\"section\"><a name=\"WS73099CC142F48755-1EB804411AF8B41570-73A0\"></a> \n               <h3><a name=\"GUID-852C29BB-EC5E-4F93-9A30-4C56514CF2AF\"></a>Converting the body and shoes to passive collision objects\n               </h3> \n               <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62E9\"></a>The last step in setting up the simulation is to convert the body and shoe meshes\n                  to passive collision objects. As passive collision objects, the body and shoe meshes\n                  will collide with the nCloth pants object. \n                  		  \n               </p> <a name=\"WS73099CC142F48755-1EB804411AF8B41570-739E\"></a><p class=\"list-intro\"><a name=\"WS73099CC142F48755-1EB804411AF8B41570-739D\"></a>To convert the body and shoe meshes to collision objects\n               </p>\n               <ol type=\"1\" start=\"1\">\n                  <li>In the scene view, Shift-select the body and shoe meshes (the \n                     				<em class=\"mild\">nCloth_Pants</em> object is no longer selected), and select \n                     				<span class=\"MenuCascade\" id=\"GUID-C90FBA7E-268C-46F1-8DCA-CB8DFC59077D\">nCloth &gt; Create Passive Collider</span> &gt; \n                     				<img src=\"../images/GUID-96432FB8-EBE9-4D1A-8DED-5173E032EBC0-low.png\">. \n                     			 \n                  </li>\n                  <li>In the Maked Collide Options window, select \n                     				<span class=\"MenuCascade\" id=\"GUID-F43430B3-638E-4FA4-B82C-6E6902DB1EFE\">nucleus1</span> from the<span class=\"MenuCascade\"> Solver</span> drop-down list. \n                     			 \n                  </li>\n                  <li>Click \n                     				<span class=\"MenuCascade\" id=\"GUID-732550F9-0E3D-48F1-9FE7-B1DDF77C6A97\">Make Collide</span>. \n                     				\n                     <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-7398\"></a>Two \n                        				  <span class=\"MenuCascade\" id=\"GUID-226F394A-DE27-4609-98A5-F42A59E54E09\">nRigid</span> nodes (<span class=\"MenuCascade\" id=\"GUID-0E5B8B86-9BA8-4CAD-8689-8774FE15C1DF\">nRigid1</span> and \n                        				  <span class=\"MenuCascade\" id=\"GUID-F73FF7A0-C58F-418D-BACA-99BA4D995CB9\">nRigid2</span>) appear in the \n                        				  <span class=\"MenuCascade\" id=\"GUID-63994DB9-0DCB-4E52-9039-DB0A64F52454\">Outliner</span>. \n                        				\n                     </p> \n                  </li>\n                  <li>To ensure the body and shoe objects are easy to identify in your scene, rename the\n                     \n                     				<span class=\"MenuCascade\" id=\"GUID-158063F6-4D09-4034-AFC2-0818BA805016\">nRidgid</span> nodes in the \n                     				<span class=\"MenuCascade\" id=\"GUID-29619AB9-020E-4A76-900E-867606C8CBF2\">Outliner</span>. To do this, double-click \n                     				<em class=\"mild\">nRigid1</em>, type \n                     				<em class=\"mild\">nRigid_Body</em>, and press Enter. Do the same for the shoes object by renaming \n                     				<em class=\"mild\">nRigid2 \n                        				</em>to \n                     				<em class=\"mild\">nRigid_Shoes</em>. \n                     				<a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-48DB\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-93923C18-708E-49DC-B307-AA5EB7AEABAF-low.png\"></div> \n                  </li>\n               </ol> \n            </div> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";